<?php
require_once "connection.php";

if (!isset($_GET['userEmail'])) {
    $response = array(
        'status' => 'error',
        'message' => 'User email is required'
    );
    header('Content-Type: application/json');
    echo json_encode($response);
    exit();
}
$userEmail = $_GET['userEmail'];

$conn = new mysqli($servername, $username, $password, $database);

if ($conn->connect_error) {
    $response = array(
        'status' => 'error',
        'message' => 'Connection failed: ' . $conn->connect_error
    );
    header('Content-Type: application/json');
    echo json_encode($response);
    exit(); 
}

$stmt = $conn->prepare("DELETE FROM user_detail WHERE userEmail = ?");
$stmt->bind_param("s", $userEmail);
if ($stmt->execute()) {
    $response = array(
        'status' => 'success',
        'message' => 'User data deleted successfully'
    );
} else {
    $response = array(
        'status' => 'error',
        'message' => 'Error deleting user data: ' . $conn->error
    );
}

$stmt->close();
$conn->close();

header('Content-Type: application/json');
echo json_encode($response);
?>
