<?php
require_once "connection.php";
 
$conn = new mysqli($servername, $username, $password, $database);
if ($conn->connect_error) {
    die("Connection failed: " . $conn->connect_error);
} 
 
header('Content-Type: application/json');
 
$userId = $_GET['userId'];
 
if ($userId !== null) { 
    $stmt = $conn->prepare("SELECT * FROM messages_details WHERE userId = ?");
     
    $stmt->bind_param("i", $userId); // Assuming userId is an integer
 
    if ($stmt->execute()) { 
        $result = $stmt->get_result();
         
        $userData = array();
         
        while ($row = $result->fetch_assoc()) {
            $userData[] = $row;
        }
         
        if (!empty($userData)) { 
            $response = array(
                'status' => 'success',
                'data' => $userData
            );
        } else { 
            $response = array(
                'status' => 'error',
                'message' => 'User not found'
            );
        }
        echo json_encode($response);
    } else { 
        $response = array(
            'status' => 'error',
            'message' => 'Failed to execute SQL statement'
        );
        echo json_encode($response);
    }
 
    $stmt->close();
} else { 
    $response = array(
        'status' => 'error',
        'message' => 'Missing userId parameter'
    );
    echo json_encode($response);
}
 
$conn->close(); 
?>
