<?php
require_once "connection.php";
 
$conn = new mysqli($servername, $username, $password, $database);
if ($conn->connect_error) {
    die("Connection failed: " . $conn->connect_error);
} 
 
$requiredParams = array('userId', 'message', 'sentBy', 'time');
  
$missingParams = array();
foreach ($requiredParams as $param) {
    if (!isset($_POST[$param])) {
        $missingParams[] = $param;
    }
}
 
if (!empty($missingParams)) {
    echo "Error: Missing POST parameters: " . implode(', ', $missingParams);
} else { 
    $stmt = $conn->prepare("INSERT INTO messages_details (userId, message, sentBy, time) VALUES (?, ?, ?, ?)");
  
    $stmt->bind_param(
        "ssss",  
        $_POST['userId'], 
        $_POST['message'], 
        $_POST['sentBy'], 
        $_POST['time']
    );  
    if ($stmt->execute()) {
        echo "New record inserted successfully";
    } else {
        echo "Error: " . $stmt->error;
    } 
 
    $stmt->close();
}  
$conn->close(); 
?>
