<?php
require_once "connection.php";
$conn = new mysqli($servername, $username, $password, $database);
if ($conn->connect_error) {
    die("Connection failed: " . $conn->connect_error);
} 

$requiredParams = array(
    'userEmail', 
    'userName', 
    'pictureUrl', 
    'pronoun', 
    'age', 
    'country', 
    'profession', 
    'shyFlirtLevel', 
    'pesimisticOptimistic', 
    'ordinayMysterious', 
    'intentions', 
    'interests'
);
 
$missingParams = array();
foreach ($requiredParams as $param) {
    if (!isset($_POST[$param])) {
        $missingParams[] = $param;
    }
}

if (!empty($missingParams)) {
    echo "Error: Missing POST parameters: " . implode(', ', $missingParams);
} else {
    $stmt = $conn->prepare("INSERT INTO user_detail (userEmail, userName, pictureUrl, pronoun, age, country, characterImage, profession, shyFlirtLevel, pesimisticOptimistic, ordinayMysterious, intentions, interests) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)");
 
    $stmt->bind_param(
        "sssssssssssss",  
        $_POST['userEmail'], 
        $_POST['userName'], 
        $_POST['pictureUrl'], 
        $_POST['pronoun'], 
        $_POST['age'], 
        $_POST['country'], 
        $_POST['characterImage'], 
        $_POST['profession'], 
        $_POST['shyFlirtLevel'], 
        $_POST['pesimisticOptimistic'], 
        $_POST['ordinayMysterious'], 
        $_POST['intentions'], 
        $_POST['interests']
    ); 

    if ($stmt->execute()) {
        echo "New record inserted successfully";
    } else {
        echo "Error: " . $stmt->error;
    } 

    $stmt->close();
} 

$conn->close(); 
?>
