<?php
require_once "connection.php";
$conn = new mysqli($servername, $username, $password, $database);
if ($conn->connect_error) {
    die("Connection failed: " . $conn->connect_error);
}
$requiredParams = array(
    'userEmail', 
    'userName'
);
$missingParams = array();
foreach ($requiredParams as $param) {
    if (!isset($_POST[$param])) {
        $missingParams[] = $param;
    }
}

if (!empty($missingParams)) {
    echo "Error: Missing POST parameters: " . implode(', ', $missingParams);
    exit();
}

$userEmail = $_POST['userEmail'];
$userName = $_POST['userName'];

$stmt = $conn->prepare("UPDATE user_detail SET userName = ? WHERE userEmail = ?");
$stmt->bind_param("ss", $userName, $userEmail);

if ($stmt->execute()) {
    echo "User name updated successfully";
} else {
    echo "Error: " . $stmt->error;
}

$stmt->close();
$conn->close();
?>
