<?php
require_once "connection.php";

$conn = new mysqli($servername, $username, $password, $database);
if ($conn->connect_error) {
    die("Connection failed: " . $conn->connect_error);
}

$requiredParams = array(
    'userEmail', 
    'pronoun'
);
$missingParams = array();
foreach ($requiredParams as $param) {
    if (!isset($_POST[$param])) {
        $missingParams[] = $param;
    }
}
if (!empty($missingParams)) {
    echo "Error: Missing POST parameters: " . implode(', ', $missingParams);
    exit();
}

$userEmail = $_POST['userEmail'];
$pronoun = $_POST['pronoun'];
$stmt = $conn->prepare("UPDATE user_detail SET pronoun = ? WHERE userEmail = ?");
$stmt->bind_param("ss", $pronoun, $userEmail);
if ($stmt->execute()) {
    echo "User name updated successfully";
} else {
    echo "Error: " . $stmt->error;
}
$stmt->close();
$conn->close();
?>
