<?php
require_once "connection.php";
$conn = new mysqli($servername, $username, $password, $database);
if ($conn->connect_error) {
    die("Connection failed: " . $conn->connect_error);
}
$requiredParams = array(
    'userEmail', 
    'shyFlirtLevel',
    'pesimisticOptimistic',
    'ordinayMysterious'
);
$missingParams = array();
foreach ($requiredParams as $param) {
    if (!isset($_POST[$param])) {
        $missingParams[] = $param;
    }
}

if (!empty($missingParams)) {
    echo "Error: Missing POST parameters: " . implode(', ', $missingParams);
    exit();
}

$userEmail = $_POST['userEmail'];
$shyFlirtLevel = $_POST['shyFlirtLevel'];
$pesimisticOptimistic = $_POST['pesimisticOptimistic'];
$ordinayMysterious = $_POST['ordinayMysterious'];

$stmt = $conn->prepare("UPDATE user_detail SET shyFlirtLevel = ?, pesimisticOptimistic = ?, ordinayMysterious = ? WHERE userEmail = ?");
$stmt->bind_param("iiis", $shyFlirtLevel, $pesimisticOptimistic, $ordinayMysterious, $userEmail);

if ($stmt->execute()) {
    echo "User details updated successfully";
} else {
    echo "Error: " . $stmt->error;
}

$stmt->close();
$conn->close();
?>
